
#include "ADC.h"
#include "p33Fxxxx.h"
#include <string.h>

#define BUFFER_SIZE_WORDS 256
signed short ADCBufA[BUFFER_SIZE_WORDS] __attribute__((space(dma)));
signed short ADCBufB[BUFFER_SIZE_WORDS] __attribute__((space(dma)));
volatile unsigned char CurrentADCDMABuffer = 0;
volatile unsigned char ADCDMABufferFull = 0;

signed short buf[BUFFER_SIZE_WORDS];

void __attribute__((__interrupt__,no_auto_psv)) _DMA0Interrupt(void) {
	if( CurrentADCDMABuffer == 0 ) {
		memcpy(buf, ADCBufA, sizeof(buf));
	} else {
		memcpy(buf, ADCBufB, sizeof(buf));
	}
	ADCDMABufferFull = 1;
	CurrentADCDMABuffer ^= 1;
	IFS0bits.DMA0IF = 0; //Clear the DMA0 Interrupt Flag
}

void adc_init() {
	AD1CON1bits.AD12B = 1;
	AD1CON3bits.ADCS = 15; // (max) 40MHz / 16 / 14 = 179kHz
	AD1CON3bits.SAMC = 10; // 14 (conversion) + 10 (sample) = 24, 24 * 16 * 2 = 768. This ensures that the ADC is synchronised with the DAC.
	AD1CON1bits.ASAM = 1;
	AD1CON1bits.SSRC = 7;  // auto-convert
	AD1CON1bits.FORM = 3;
	AD1CON1bits.ADDMABM = 1;
	AD1CON2bits.CSCNA = 1; // scan inputs
	AD1CSSLbits.CSS4 = 1;
	AD1CSSLbits.CSS5 = 1;
	AD1CHS0bits.CH0SA = 4;

	IFS0bits.AD1IF = 0;
	IEC0bits.AD1IE = 0;

	DMA0CONbits.AMODE = 0;	// Configure DMA for Register indirect mode with post-increment
	DMA0CONbits.MODE = 2;	// Configure DMA for Continuous Ping-Pong mode
	DMA0PAD = 0x0300;		// Point DMA to ADC1BUF0
	DMA0CNT = BUFFER_SIZE_WORDS-1;
	DMA0REQ = 13;			// Select ADC1 as DMA Request source
	DMA0STA = __builtin_dmaoffset(&ADCBufA);
	DMA0STB = __builtin_dmaoffset(&ADCBufB);
	IFS0bits.DMA0IF = 0;	//Clear the DMA interrupt flag bit	
	IEC0bits.DMA0IE = 1;	//Set the DMA interrupt enable bit
	DMA0CONbits.CHEN = 1;

	AD1CON1bits.ADON = 1;
	AD1CON1bits.SAMP = 1;
}

void adc_stop() {
	AD1CON1bits.ADON = 0;
}

signed short* adc_get_data() {
	if( ADCDMABufferFull ) {
		ADCDMABufferFull = 0;
		return buf;
	} else {
		return (signed short*)0;
	}
}

